/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.css.core.parsing.CSSTokenType;
import com.aptana.css.core.parsing.CSSTokenTypeSymbol;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import com.aptana.editor.css.CSSCodeScannerRuleBased;
import com.aptana.editor.css.parsing.CSSColoringFlexScanner;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CSSCodeScannerFlex
extends AbstractFlexTokenScanner {
    private int fCurlyState;
    private boolean fInMedia;
    protected boolean fInPropertyValue;
    protected boolean fInSelector;
    private String fContextToAppend = "";
    private static final Set<String> HTML_TAGS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.HTML_TAGS);
    private static final Set<String> PROPERTY_NAMES = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.PROPERTY_NAMES);
    private static final Set<String> PROPERTY_VALUES = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.PROPERTY_VALUES);
    private static final Set<String> FUNCTIONS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.FUNCTIONS);
    private static final Set<String> FONT_NAMES = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.FONT_NAMES);
    private static final Set<String> MEDIA = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.MEDIA);
    private static final Set<String> STANDARD_COLORS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.STANDARD_COLORS);
    private static final Set<String> DEPRECATED_COLORS = CollectionsUtil.newSet((Object[])CSSCodeScannerRuleBased.DEPRECATED_COLORS);
    private IToken tokenOnWhitespace;

    public CSSCodeScannerFlex() {
        super((Scanner)new CSSColoringFlexScanner());
    }

    protected void setSource(String string) {
        ((CSSColoringFlexScanner)this.fScanner).setSource(string);
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fCurlyState = 0;
        this.fInMedia = false;
        this.fInPropertyValue = false;
        this.fInSelector = false;
        if (offset > 0) {
            String previous = null;
            try {
                ITypedRegion[] partitions;
                ITypedRegion[] iTypedRegionArray = partitions = document.computePartitioning(0, offset);
                int n = partitions.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypedRegion region = iTypedRegionArray[n2];
                    if (!("__css_multiline_comment".equals(region.getType()) || "__css_string_double".equals(region.getType()) || "__css_string_single".equals(region.getType()))) {
                        previous = document.get(region.getOffset(), region.getLength());
                        Matcher m = CSSCodeScannerRuleBased.CURLY_MEDIA_PATTERN.matcher(previous);
                        while (m.find()) {
                            String found = m.group();
                            if ("{".equals(found)) {
                                ++this.fCurlyState;
                                continue;
                            }
                            if ("}".equals(found)) {
                                --this.fCurlyState;
                                if (this.fCurlyState > 0 || !this.fInMedia) continue;
                                this.fInMedia = false;
                                continue;
                            }
                            if (!"@media".equals(found)) continue;
                            this.fInMedia = true;
                            this.fCurlyState = 0;
                        }
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.buildContext();
    }

    protected IToken mapToken(Symbol symbol) throws IOException, Scanner.Exception {
        CSSTokenType tokenData;
        CSSTokenTypeSymbol tokenTypeSymbol = (CSSTokenTypeSymbol)symbol;
        switch (tokenTypeSymbol.token) {
            case IDENTIFIER: {
                if (HTML_TAGS.contains(symbol.value)) {
                    tokenData = CSSTokenType.ELEMENT;
                    break;
                }
                if (FUNCTIONS.contains(symbol.value)) {
                    tokenData = CSSTokenType.FUNCTION;
                    break;
                }
                if (PROPERTY_VALUES.contains(symbol.value)) {
                    tokenData = CSSTokenType.VALUE;
                    break;
                }
                if (STANDARD_COLORS.contains(symbol.value)) {
                    tokenData = CSSTokenType.COLOR;
                    break;
                }
                if (DEPRECATED_COLORS.contains(symbol.value)) {
                    tokenData = CSSTokenType.DEPRECATED_COLOR;
                    break;
                }
                if (PROPERTY_NAMES.contains(symbol.value)) {
                    tokenData = CSSTokenType.PROPERTY;
                    break;
                }
                if (MEDIA.contains(symbol.value)) {
                    tokenData = CSSTokenType.MEDIA;
                    break;
                }
                if (FONT_NAMES.contains(((String)symbol.value).toLowerCase())) {
                    tokenData = CSSTokenType.FONT;
                    break;
                }
                if (CSSCodeScannerRuleBased.VENDOR_WORD_RULE.wordOK((String)symbol.value, null)) {
                    tokenData = CSSTokenType.PROPERTY;
                    break;
                }
                tokenData = CSSTokenType.IDENTIFIER;
                break;
            }
            case EOF: {
                return Token.EOF;
            }
            default: {
                tokenData = tokenTypeSymbol.token;
            }
        }
        return this.makeTokenWithContext(tokenData, false);
    }

    protected IToken getWhitespace() {
        return this.makeTokenWithContext(null, true);
    }

    protected IToken getUndefinedToken() {
        return new Token((Object)CSSTokenType.UNDEFINED.getScope());
    }

    private IToken makeTokenWithContext(CSSTokenType tokenData, boolean isWhitespace) {
        if (CSSTokenType.MEDIA_KEYWORD == tokenData) {
            this.fInMedia = true;
            this.fCurlyState = 0;
            this.buildContext();
        } else if (CSSTokenType.LCURLY == tokenData) {
            if (this.fInMedia && this.fCurlyState == 0) {
                tokenData = CSSTokenType.LCURLY_MEDIA;
            }
            ++this.fCurlyState;
            this.buildContext();
        } else if (CSSTokenType.RCURLY == tokenData) {
            this.fInPropertyValue = false;
            this.buildContext();
        } else if (CSSTokenType.PROPERTY == tokenData) {
            this.fInSelector = false;
            this.buildContext();
        } else if (CSSTokenType.COLON == tokenData) {
            this.fInPropertyValue = true;
            this.buildContext();
        } else if (CSSTokenType.CLASS == tokenData || CSSTokenType.ID == tokenData || CSSTokenType.STAR == tokenData || CSSTokenType.ELEMENT == tokenData) {
            this.fInSelector = true;
            this.buildContext();
        }
        IToken ret = null;
        if (!this.fInPropertyValue && CSSTokenType.VALUE == tokenData) {
            tokenData = CSSTokenType.PROPERTY;
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.LCURLY == tokenData) {
            this.fInSelector = false;
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.RCURLY == tokenData) {
            --this.fCurlyState;
            if (this.fCurlyState <= 0 && this.fInMedia) {
                tokenData = CSSTokenType.RCURLY_MEDIA;
                this.fInMedia = false;
            }
            ret = this.computeReturn(tokenData, isWhitespace);
            this.buildContext();
        } else if (CSSTokenType.SEMICOLON == tokenData) {
            ret = this.computeReturn(tokenData, isWhitespace);
            this.fInPropertyValue = false;
            this.buildContext();
        } else {
            ret = this.computeReturn(tokenData, isWhitespace);
        }
        return ret;
    }

    private IToken computeReturn(CSSTokenType tokenData, boolean isWhitespace) {
        if (isWhitespace) {
            return this.tokenOnWhitespace;
        }
        if (tokenData != null) {
            String scope = tokenData.getScope();
            int contextLen = this.fContextToAppend.length();
            if (contextLen == 0) {
                return new Token((Object)scope);
            }
            int scopeLen = scope.length();
            char[] array = new char[contextLen + scopeLen];
            this.fContextToAppend.getChars(0, contextLen, array, 0);
            scope.getChars(0, scopeLen, array, contextLen);
            return new Token((Object)new String(array));
        }
        return new Token((Object)CSSTokenType.UNDEFINED.getScope());
    }

    private void buildContext() {
        StringBuilder builder = null;
        if (this.fInMedia) {
            builder = new StringBuilder(56);
            builder.append(CSSTokenType.META_MEDIA.getScope()).append(' ');
        }
        if (this.fInMedia ? this.fCurlyState > 1 : this.fCurlyState > 0) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_RULE.getScope()).append(' ');
        } else if (this.fInSelector) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_SELECTOR.getScope()).append(' ');
        }
        if (this.fInPropertyValue) {
            builder = builder != null ? builder : new StringBuilder(56);
            builder.append(CSSTokenType.META_PROPERTY_VALUE.getScope()).append(' ');
        }
        if (builder == null) {
            this.fContextToAppend = "";
            this.tokenOnWhitespace = Token.WHITESPACE;
        } else {
            this.fContextToAppend = builder.toString();
            this.tokenOnWhitespace = new Token((Object)this.fContextToAppend.substring(0, builder.length() - 1));
        }
    }
}

